package com.corejdo.examples.chapter5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Book;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Book
 *
 */
public class RetrieveExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw w  wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    Extent extent = pm.getExtent(Book.class, true);

    Iterator books = extent.iterator();
    
    System.out.println("Lista wszystkich ksiek:");
    
    List list = new ArrayList(1024);
          
    while (books.hasNext()) {
    
      list.add(books.next());
      
      if (list.size() == 1024 || !books.hasNext()) {
    
        pm.retrieveAll(list);
        
        for (int i = 0; i < list.size(); ++i) {
                      
          Book book = (Book) list.get(i);
    
          System.out.println("  " + book.getTitle());
        }
      
        pm.evictAll(list);      
        
        list.clear();
      }
    }

    extent.close(books);
        
    tx.commit();
    
    pm.close();
  }
  
  private RetrieveExample() {}
}
