package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 *
 */
public class PersistenceManagerExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = null;

    try {

      pm = pmf.getPersistenceManager();

      // Operacje w bazie danych

      pm.close();
    }

    finally {

      if (pm != null && !pm.isClosed()) {

        if (pm.currentTransaction().isActive()) {

          pm.currentTransaction().rollback();
        }

        pm.close();
      }
    }
  }
  
  private PersistenceManagerExample() {}
}
