package com.corejdo.examples.chapter5;

import java.io.FileInputStream;
import java.util.Properties;

import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;

/**
 * @author mccammon
 *
 */
public class PMFSingletonFromFileExample {

  // singleton PersistenceManagerFactory 
  private static PersistenceManagerFactory pmf;

  /**
   * <p>Metoda ta zwraca singleton
   * PersistenceManagerFactory. Jeli singleton 
   * nie zosta zainicjowany, to tworzy instancj PersistenceManagerFactory
   * na podstawie waciwoci umieszczonych w pliku okrelonego
   * za pomoc waciwoci systemowej "jdo.properties"
   * i inicjuje singleton.</p>
   * 
   * @throws JDOFatalUserException jeli wystpi bd podczas 
   * tworzenia instancji PersistenceManagerFactory
   * 
   * @return singleton PersistenceManagerFactory 
   */
  public static PersistenceManagerFactory getPersistenceManagerFactory() {

    if (pmf == null) {

      String filename = System.getProperty("jdo.properties");

      if (filename == null) {

        throw new JDOFatalUserException("Waciwo systemowa 'jdo.properties' nie jest zdefiniowana");
      }

      else {

        Properties properties = new Properties();

        try {

          properties.load(new FileInputStream(filename));

          pmf = JDOHelper.getPersistenceManagerFactory(properties);
        }

        catch (java.io.IOException e) {

          throw new JDOFatalUserException(
            "Bd odczytu pliku '" + filename + "'",
            e);
        }
      }
    }

    return pmf;
  }
  
  private PMFSingletonFromFileExample() {}
}
