package com.corejdo.examples.chapter5;

import java.util.Properties;

import javax.jdo.JDOHelper;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManagerFactory;

/**
 * @author mccammon
 *
 */
public class PMFSingletonExample {
  
  // singleton PersistenceManagerFactory 
  private static PersistenceManagerFactory pmf;
  
  /**
   * <p>Metoda ta zwraca singleton PersistenceManagerFactory.
   * Jeli singleton nie zosta zainicjowany, to wyrzuca 
   * wyjtek JDOFatalUserException. Metoda initialize()
   * powinna by wywoana przed t metod.</p>
   * 
   * @return instancja PersistenceManagerFactory
   */
  public static PersistenceManagerFactory getPersistenceManagerFactory() {
    
    if (pmf == null) {
      
     throw new JDOUserException("PersistenceManagerFactory nie zainicjowana.");
    }
    
    return pmf;
  }

  /**
   * <p>Tworzy PersistenceManagerFactory na podstawie
   * podanych waciwoci i inicjuje singleton.
   * PersistenceManagerFactoryClass musi by wyspecyfikowana zamiast "XXX".</p>
   * 
   * @param url adres URL poczenia
   * @param name nazwa uytkownika bazy danych
   * @param password haso uytkownika bazy danych
   */
  public static void intialize(String url, String name, String password) {

    Properties properties = new Properties();
    
    properties.put(
      "javax.jdo.PersistenceManagerFactoryClass", "XXX");
    properties.put(
      "javax.jdo.option.ConnectionURL", url);
    properties.put(
      "javax.jdo.option.ConnectionUserName", name);
    properties.put(
      "javax.jdo.option.ConnectionPassword", password);

    pmf = JDOHelper.getPersistenceManagerFactory(properties);
  }
  
  private PMFSingletonExample() {}
}
