package com.corejdo.examples.chapter5;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class NonTransactionalReadExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.setNontransactionalRead(true);
    
    tx.begin();
    
    Author author = new Author("Keiron McCammon");
    
    pm.makePersistent(author);
    
    tx.commit();
    
    // Instancja klasy Author przechodzi do stanu pustego
    // po zatwierdzeniu transakcji
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'.");
    
    // Instancja klasy Author zostaje pobrana z bazy danych
    // i staje si nietransakcyjna.
    
    if (!JDOHelper.isTransactional(author)) {
      
      System.out.println("Instancja klasy Author staa si nietransakcyjna.");
    }
 
    pm.close();
  }
  
  private NonTransactionalReadExample() {}
}
