package com.corejdo.examples.chapter3;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public final class UniquingExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    /*
     * Tworzy now instancj klasy Author
     */
    Author author1 = new Author("Keiron McCammon");
    
    pm.makePersistent(author1);
    
    tx.commit();
    
    tx.begin();
    
    /*
     * Wyszukuje utworzon wczeniej instancj klasy Author za pomoc zapytania Query
     */
    Query query =
      pm.newQuery(Author.class, "name == \"Keiron McCammon\"");
    
    Collection authors = (Collection) query.execute();
    
    Author author2 = (Author) authors.iterator().next();
    
    query.close(authors);
    
    tx.commit();

    /*
     * Sprawdza, e obie referencje dotycz tego samego obiektu Java
     */
    if (author1 == author2)
      System.out.println("W pamici znjaduje si jeden i ten sam obiekt");
    
    pm.close();
  }
  
  private UniquingExample() {}
}
