package com.corejdo.examples.chapter3;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * 
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public final class ReadByNavigationExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main ( String[] args ) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    /*
     * Tworzy now instancj klasy Author i utrwala j w bazie danych
     */    
    tx.begin();
    
    Author author = new Author("Keiron McCammon");

    pm.makePersistent(author);
    
    tx.commit();

    /*
     * Po zakoczeniu transakcji wartoci pl instancji klasy Author 
     * nie s dostpne w pamici, ale referencja tej instancji jest nadal wana
     */
     
    tx.begin();

    /*
     * Prba dostpu do instancji klasy Author podczas kolejnej transakcji
     * spowoduje transaprentne pobranie wartoci pl z bazy danych
     */   
    String name = author.getName();
    
    System.out.println("Nazwisko autora: '" + name + "'.");
    
    tx.commit();
    
    pm.close();
  }
  
  private ReadByNavigationExample() {}
}
