package com.corejdo.examples.chapter3;

import java.io.FileInputStream;
import java.util.Properties;

import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

/**
 * @author mccammon
 *
 */
public final class MakeConnectionFromFileExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry wiersza polece
   */
  public static void main(String[] args) {

    String filename = System.getProperty("jdo.properties");

    if (filename == null) {

      throw new 
        JDOFatalUserException("Waciwo systemowa 'jdo.properties' nie zostaa zdefiniowana");
    }

    Properties properties = new Properties();

    try {

      properties.load(new FileInputStream(filename));
    }

    catch (java.io.IOException e) {

      throw new
        JDOFatalUserException("Bd podczas odczytu '" + filename + "'", e);
    }

    PersistenceManagerFactory pmf =
      JDOHelper.getPersistenceManagerFactory(properties);
  
    PersistenceManager pm = pmf.getPersistenceManager();

    /* Operacje w bazie danych */
  
    pm.close();
  }
  
  private MakeConnectionFromFileExample() {}
}
