package com.corejdo.casestudy.usecase;



import java.util.Collection;
import java.util.Date;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;

import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.model.User;

/**
 * Zwraca status uytkownika (liczb wypoyczonych ksiek, dat zwrotu etc.).
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class UserStatus extends AbstractUseCase
{
    public static void main(String[] args)
    {
        new UserStatus().runCmdLine(args);
    }

    /**
     * Wersja uruchamiana w wierszu polece.
     */
    protected void run(String[] args)
    {
        execute();
        for (int i = 0; i < info.length; i++) {
            System.out.println("Title:  "+info[i].title);
            System.out.println("Return: "+info[i].returnDate);
        }
    }

    protected void _execute()
    {
        // wyszukuje pozycje wypoyczone przez uytkownika:
        Copy copies[] = findCopies(getContext().user);
        info = new BorrowInfo[copies.length];
        for (int i = 0; i < copies.length; i++) {
            info[i] = new BorrowInfo();
            info[i].returnDate = copies[i].returnDate.toString();
            info[i].title = copies[i].copyOf.title;
            info[i].timeOver = copies[i].returnDate.after(new Date());
        }
    }

    /**
     * Wyszukuje wszystkie kopie wypoyczone przez uytkownika.
     */
    protected Copy[] findCopies(User user)
    {
        PersistenceManager pm = getPM();
        Query q = pm.newQuery(Copy.class, "borrower == val");
        q.declareParameters("com.corejdo.casestudy.model.User val");
        q.setCandidates(pm.getExtent(Copy.class,true));
        Collection result = (Collection)q.execute(user);
        Copy copies[] = new Copy[result.size()];
        result.toArray(copies);
        return copies;
    }
    public BorrowInfo[] getInfo()
    {
        return info;
    }

    public class BorrowInfo
    {
        public String title;
        public String returnDate;
        public boolean timeOver;
    }

    BorrowInfo info[];
}
