package com.corejdo.casestudy.usecase;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;

import com.corejdo.casestudy.model.User;

/**
 * Klasa bazowa dla wszystkich operacji na uytkownikach.
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public abstract class UserOperation extends AbstractUseCase
{

    public UserOperation()
    {
    }

    /**
     * Wyszukuje uytkownika o identyfikatorze findId.
     */
    protected User findUser()
    {
        PersistenceManager pm = getPM();
        Query q = pm.newQuery(User.class, "id == val");
        q.declareParameters("java.lang.String val");
        q.setCandidates(pm.getExtent(User.class,true));
        Collection result = (Collection)q.execute(findId);
        if (result.size()<1) {
            throw new UserNotFoundException(findId);
        } else if (result.size()>1) {
            throw new RuntimeException("Identyfikator "+findId+" nie jest unikalny");
        }
        User user = (User)result.iterator().next();
        return user;
    }

    public void setFindUser(String findId)
    {
        this.findId = findId;
    }
    public String getFindUser()
    {
        return findId;
    }

    private String findId;

    public static class UserNotFoundException extends UseCaseException
    {
        public UserNotFoundException(String userName)
        {
            super(userName);
        }
    }

}
