package com.corejdo.casestudy.usecase;

import java.util.Collection;

import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

import com.corejdo.casestudy.model.Rights;
import com.corejdo.casestudy.model.User;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Klasa implementuje bezpieczestwo na poziomie aplikacji. Rozwizania
 * w zakresie bezpieczestwa oferowane przez baz danych nie s uywane, 
 * zamiastr nich tworzymy wasn warstw bezpieczestwa ponad JDO.
 * Zalogowanie uytkownika powoduje aktualizacj kontekstu sesji. Inne
 * operacje aplikacji uzyskuj informacje o uytkowniku za pomoc referencji
 * kontekstu. 
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class Login extends AbstractUseCase
{
    /**
     * Testuje mechanizm logowania.
     * @param args nie s uywane.
     */
    public void main(String args[])
    {
        new Login().runCmdLine(args);
    }

    /**
     * Testuje mechanizm logowania.
     */
    protected void run(String[] args)
    {
        setUserId(CmdLine.getStringVar("Identyfikator:",""));
        setPassword(CmdLine.getStringVar("Haso:",""));
        execute();
    }

    private void error()
    {
        throw new UseCaseException("Niedozwolony identyfikator lub haso.");
    }

    /**
     * Metoda wywoywana przez klas bazow
     * w kontekcie aktywnej transakcji JDO.
     */
    protected void _execute()
    {
        User user = null;
        if (this.userId == null || this.userId.length() == 0) {

            getContext().userRights = new Rights(); 
        } else {

            user = findUser();
            if (!user.checkPassword(password)) error();
            getContext().userRights = user.getRights().copy();
        }
        getContext().user = user;
    }

    public boolean isLoggedIn()
    {
        return getContext().user != null;
    }

    /**
     * Wstawia administratora.
     */
    protected void checkInitialUser()
    {
        PersistenceManager pm = getPM();
        Extent e = pm.getExtent(User.class,true);
        if (e.iterator().hasNext()) {
            return ;
        }
        User u = new User();
        u.setFirstName("Heiko");
        u.setLastName("Bobzin");
        u.setPassword("hb");
        u.setId("hb");

        pm.makePersistent(u);
        pm.currentTransaction().commit();
        pm.currentTransaction().begin();
    }

    /**
     * Wyszukuje uytkownika w bazie danych.
     * @return uytkownik
     */
    protected User findUser()
    {
        checkInitialUser();
        PersistenceManager pm = getPM();
        Query q = pm.newQuery(User.class, "id == val");
        q.declareParameters("String val");
        q.setCandidates(pm.getExtent(User.class,true));
        Collection result = (Collection)q.execute(userId);
        if (result.size() != 1) error();
        User user = (User)result.iterator().next();
        return user;
    }


    public void setUserId(String userId)
    {
        this.userId = userId;
    }
    public void setPassword(String password)
    {
        this.password = password;
    }
    private String userId;
    private String password;
}
