package com.corejdo.casestudy.usecase;


import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Klasa uywana do zmiany waciwoci ksiek.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class EditBook extends BookOperation
{
    public static void main(String[] args)
    {
        new EditBook().runCmdLine(args);
    }

    /**
     * Wersja edytora dostpna w wierszu polece.
     *
     */
    protected void run(String[] args)
    {
        setFindISBN(CmdLine.getStringVar("Podaj ISBN","928394-234-23444"));
        setFindTitle(CmdLine.getStringVar("Podaj tytu",""));
        setISBN(CmdLine.getStringVar("ISBN","928394-234-23444"));
        setTitle(CmdLine.getStringVar("Tytu","new Title"));
        setAuthor(CmdLine.getStringVar("Autor","H. Bobzin"));
        setCopyright(CmdLine.getStringVar("Copyright","(C) 2003 Prentice Hall"));
        execute();
    }


    /**
     * Wyszukuje ksik, a nastpnie aktualizuje jej pola
     * wartociami tego ziarnka.
     */
    protected void _execute()
    {
        Book book = findBook();
        book.title = this.title;
        book.author = this.author;
        book.copyright = this.copyright;
        book.ISBN = this.ISBN;
    }

    public void setISBN(String ISBN)
    {
        this.ISBN = ISBN;
    }
    public void setAuthor(String author)
    {
        this.author = author;
    }
    public void setTitle(String title)
    {
        this.title = title;
    }
    public void setCopyright(String copyright)
    {
        this.copyright = copyright;
    }
    private String ISBN;
    private String author;
    private String title;
    private String copyright;

}
