package com.corejdo.casestudy.usecase;

import com.corejdo.casestudy.model.Book;

/**
 * Klasa ta implementuje operacje wypoyczania i zwracania ksiki.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public abstract class BorrowReturn extends BookOperation
{
    public boolean isAllowed()
    {
        if (!getContext().isLoggedIn()) return false;
        return getContext().userRights.canBorrow();
    }

    /**
     * Wyszukuje ksik, a nastpnie sprawdza dostpno kopii.
     * Jeli kopia istnieje, to ksika jest wypoyczana (lub zwracana).
     */
    protected void _execute()
    {
        Book book = findBook();
        process(book);
    }

    protected abstract void process(Book book);

    public String getLocation()
    {
        return location;
    }
    public String getReturnDate()
    {
        return returnDate;
    }

    protected String returnDate;
    protected String location;

}
