package com.corejdo.casestudy.usecase;


import java.util.Date;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Kopia ksiki zostaje wyszukana i oznaczona jako "wypoyczona".
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class BorrowPublication extends BorrowReturn
{
    public static void main(String[] args)
    {
        new BorrowPublication().runCmdLine(args);
    }

    /**
     * Wersja edytora dostpna w wierszu polece.
     */
    protected void run(String[] args)
    {
        setFindISBN(CmdLine.getStringVar("Podaj ISBN","1-2153-1882-3"));
        execute();
        System.out.println("We kopi ksiki z "+location);
    }

    public final long borrowTime = 1000L*60L*10L; // dziesi minut

    protected void process(Book book)
    {
        Copy copy[] = findCopies(book);
        for (int i = 0; i < copy.length; i++) {
            Copy c = copy[i];
            if (c.borrower == null) {
                c.borrower = getContext().user;
                c.borrowDate = new Date(); // teraz
                c.returnDate = new Date(c.borrowDate.getTime()+borrowTime);
                this.returnDate = c.returnDate.toString();
                this.location = c.location;
                return;
            }
        }
        throw new UseCaseException("Wszystkie egzemplarze s wypoyczone.");
    }

}
