package com.corejdo.casestudy.usecase;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.model.Publication;

/**
 * Klasa bazowa dla wszystkich operacji na ksikach.
 * Umoliwia rwnie wyszukanie pojedynczej ksiki.
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public abstract class BookOperation extends AbstractUseCase
{

    public BookOperation()
    {
    }

    /**
     * Wyszukuje pojedyncz ksik.
     * @param nazwa pola klasy Book.
     * @param szukana warto pola
     * @return instancj klasy Book
     */
    protected Book findBook(String field, String fieldValue)
    {
        PersistenceManager pm = getPM();
        //zapytanie wyszukujce ksik
        Query q = pm.newQuery(Book.class, field+" == val");
        q.declareParameters("String val");
        q.setCandidates(pm.getExtent(Book.class,true));
        Collection result = (Collection)q.execute(fieldValue);
        if (result.size()<1) {
            throw new RuntimeException(field+" nie istnieje: "+fieldValue);
        } else if (result.size()>1) {
            throw new RuntimeException(field+" nie jest unikalne: "+fieldValue);
        }
        Book book = (Book)result.iterator().next();
        return book;
    }

    protected final Book findBook()
    {
        Book book = null;
        try {
            book = findBook("ISBN",this.findISBN);
        } catch (Exception e) {
            book = findBook("title",this.findTitle);
        }
        return book;
    }

    /**
     * Wyszukuje wszystkie kopie publikacji.
     */
    protected Copy[] findCopies(Publication publication)
    {
        PersistenceManager pm = getPM();
        // wyszukuje wszystkie kopie publikacji
        Query q = pm.newQuery(Copy.class, "copyOf == val");
        q.declareParameters("com.corejdo.casestudy.model.Publication val");
        q.setCandidates(pm.getExtent(Copy.class,true));
        Collection result = (Collection)q.execute(publication);
        Copy copies[] = new Copy[result.size()];
        result.toArray(copies);
        return copies;
    }

    public void setFindTitle(String findTitle)
    {
        this.findTitle = findTitle;
    }
    public void setFindISBN(String findISBN)
    {
        this.findISBN = findISBN;
    }
    private String findTitle;
    private String findISBN;
}
