package com.corejdo.casestudy.model;
import java.util.Collection;
import java.util.Date;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

/**
 * Klasa zawierajca oglne informacje wsplne dla rnych
 * rodzajw publikacji.
 *
 * <BR><FONT Color="red"><B>Trwaa</B></FONT>
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */
public abstract class Publication
{
    /**
     * Tytu publikacji.
     */
    public String title;
    /**
     * Data wydania.
     */
    public Date published;
    /**
     * Data pierwszego wydania.
     */
    public Date firstPublished;
    /**
     * Prawa autorskie.
     */
    public String copyright;

    /**
     * Bibliotekarz, ktry wprowadzi publikacj.
     */
    public User insertedBy;

    public Publication() {
    }

    public String toString()
    {
        return "\n Tytu: "+title+
        "\n Wydana: "+published+
        "\n Data pierwszego wydania: "+firstPublished+
        "\n Copyright: "+copyright;
    }

    public String toHTMLTitle(String linkPrefix)
    {
        return "<TD CLASS=pubTitle>"+title+"</TD>";
    }

    public String toHTMLRest(String linkPrefix)
    {
        return
        "<TD CLASS=pubPubFirst>"+firstPublished+"</TD>"+
        "<TD CLASS=pubCopyright>"+copyright+"</TD>";
    }

    public abstract String toHTML(String linkPrefix);

    /**
     */
    public Copy[] getCopies()
    {
        PersistenceManager pm = JDOHelper.getPersistenceManager(this);
        // znajduje kopie
        Query q = pm.newQuery(Copy.class, "copyOf == val");
        q.declareParameters("com.corejdo.casestudy.model.Publication val");
        q.setCandidates(pm.getExtent(Copy.class,true));
        Collection result = (Collection)q.execute(this);
        Copy[] copies = new Copy[result.size()];
        result.toArray(copies);
        return copies;
    }


}
