package com.corejdo.examples.chapter7;

import com.corejdo.examples.model.*;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

import javax.jdo.*;
import java.util.Date;

public class SeedDatabaseForQueries {

    public static void main(String[] args) throws Exception {

    // Plik waciwoci zawiera wszystkie waciwoci konfiguracji
        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();

// tworzy i utrwala obiekty
        Transaction tx = pm.currentTransaction();
        tx.begin();

        // tworzy obiekty reprezentujce autora, jego adres i ksik
        Book book1= new Book("Who let the dogs out","28277222",new Date());
        Publisher publisher1= new Publisher("Pet publishin Co");
        book1.setPublisher(publisher1);

        Address address1= new Address("1 Main Street","Burlington","02929","MA");
        Author author1 = new Author("Snoop Smith",address1);
        author1.addBook(book1);
        // utrwala obiekt author1 
        pm.makePersistent(author1);

        // tworzy obiekty reprezentujce autora, jego adres i ksik
        Book book2= new Book("Learn Java Today","82098123",new Date());
        Publisher publisher2= new Publisher("Books123.com");
        book2.setPublisher(publisher2);

        Address address2= new Address("12 Park Av","New York","10221","NY");
        Author author2 = new Author("Steven Jones",address2);
        author2.addBook(book2);
       // utrwala obiekt author2 
        pm.makePersistent(author2);

        // tworzy obiekty reprezentujce autora, jego adres i ksik
        Book book3= new Book("EJB for Dummies","2938723897",new Date());
        Publisher publisher3= new Publisher("Java Book Co");
        book3.setPublisher(publisher3);

        Address address3= new Address("72A Lakeside View Drive","Hudson","03088","NH");
        Author author3 = new Author("Lisa Knowles",address3);
        author3.addBook(book3);
        // utrwala obiekt author3 
        pm.makePersistent(author3);


        // tworzy autora posiadajcego tylko adres i dodaje go jako wspautora utworzonej 
        // wczeniej ksiki
        Address address4= new Address("72A Lakeside View Drive","Hudson","03088","NH");
        Author author4 = new Author("John Knowles",address4);
        author4.addBook(book3);
        // utrwala obiekt author4 
        pm.makePersistent(author4);
        tx.commit();
        pm.close();

    }
}
