package com.corejdo.examples.chapter5;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class RetainValuesExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw w  wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.setRetainValues(true);
    
    tx.begin();
    
    Author author = new Author("Keiron McCammon");
    
    pm.makePersistent(author);
    
    tx.commit();
    
    /*
     * Instancja klasy Author staje si nietransakcyjna
     * po zatwierdzeniu transakcji, a jej wartoci pl pozostaj w pamici
     */
    if (!JDOHelper.isTransactional(author)) {
      
      System.out.println("Instancja klasy Author staa si nietransakcyjna.");
    }
    
    System.out.println("Nazwisko autora: '" + author.getName() + "'.");
    
    pm.close();
  }
  
  private RetainValuesExample() {}
}
