package com.corejdo.examples.chapter5;

import java.util.Iterator;

import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Book;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Book
 *
 */
public class ExtentExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    Extent extent = pm.getExtent(Book.class, true);
    
    Iterator books = extent.iterator();
    
    System.out.println("Lista wszystkich ksiek:");
    
    while (books.hasNext()) {
    
      Book book = (Book) books.next();
    
      System.out.println("  " + book.getTitle());
    }
    
    extent.close(books);
    
    tx.commit();
    
    pm.close();
  }
  
  private ExtentExample() {}
}
