package com.corejdo.casestudy.usecase;
import javax.jdo.PersistenceManager;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.tools.CmdLine;

public class DeleteBook extends BookOperation
{
    public static void main(String[] args)
    {
        new DeleteBook().runCmdLine(args);
    }

    /**
     * Wersja dostpna w wierszu polece.
     */
    protected void run(String[] args)
    {
        setFindISBN(CmdLine.getStringVar("Podaj ISBN","928394-234-23444"));
        setFindTitle(CmdLine.getStringVar("Podaj tytu",""));
        execute();
    }

    public boolean isAllowed()
    {
        return getContext().userRights.canManage();
    }

    /**
     * Wyszukuje ksik, a nastpnie usuwa j.
     */
    protected void _execute()
    {
        Book book = findBook();
        PersistenceManager pm = getPM();
        pm.deletePersistent(book);
    }
}
