package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class StringObjectIdentityExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw w  wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    Author author = new Author("Keiron McCammon");
    
    pm.makePersistent(author);
    
    tx.commit();
    
    String oid = pm.getObjectId(author).toString();
    
    System.out.println("Tosamo obiektu klasy Author: " + oid);
    
    pm.close();
    
    PersistenceManager pm2 = pmf.getPersistenceManager();
    
    Transaction tx2 = pm2.currentTransaction();
    
    tx2.begin();
    
    Author author2 =
      (Author) pm.getObjectById(
        pm.newObjectIdInstance(Author.class, oid),
        true);
    
    System.out.println("Nazwisko autora: " + author2.getName());
    
    tx2.commit();

    pm2.close();
  }
}
