package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 *
 */
public class RefreshExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga podania parametrw w wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Author author = new Author("Keiron McCammon");
        
    pm.makePersistent(author);

    tx.commit();
    
    tx.begin();

    System.out.println("Nazwisko autora: '" + author.getName() + "'.");

    author.setName("Sameer Tyagi");

    System.out.println("Nazwisko autora zmienione na: '" + author.getName() + "'.");

    pm.refresh(author);

    System.out.println(
      "Nazwisko autora po operacji refresh: '" + author.getName() + "'.");

    tx.commit();

    pm.close();
  }
  
  private RefreshExample() {}
}
