package com.corejdo.examples.chapter3;

import java.util.Collection;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * 
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.chapter3.CreateExample
 *
 */
public final class UpdateWithRollbackExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main ( String[] args ) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    /*
     * Wyszukuje instancj klasy Author na podstawie wartoci pola name
     */
    Query query = pm.newQuery(Author.class, "name == \"Keiron McCammon\"");
    
    Collection result = (Collection) query.execute();
    
    Author author = (Author) result.iterator().next();
    
    query.close(result);
    
    /*
     * Modyfikuje warto pola name
     */
    author.setName("Sameer Tyagi");

    /*
     * Odwouje transakcj
     */    
    tx.rollback();

    tx.begin();
 
    String name = author.getName();
           
    /*
     * Sprawdza, e warto pola name w bazie danych nie ulega zmianie
     */           
    System.out.println("Nazwisko autora: '" + name + "'.");
    
    tx.commit();
    
    pm.close();
  }
  
  private UpdateWithRollbackExample() {}
}
