package com.corejdo.casestudy.usecase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.jdo.Extent;
import javax.jdo.Query;

import com.corejdo.casestudy.model.Publication;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Tworzy list publikacji .
 *
 * W pornaniu do klasy ListBooks operation, zwraca jedynie sformatowany tekst
 * lub dane w formacie HTML. 
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class ListPublications
    extends AbstractUseCase
{
    int startNumber = 0;
    int count = 20;

    /**
     */
    String result[];

    String prefix = "";

    Extent extent;

    /**
     * Okrela pozycj pocztkow. Poniewa JDO nie obsuguje operacji "seek" 
     * dla ekstensji, to implementujemy wasn wywoujc metod iterator.next().
     * @param i
     */
    public void setStartNumber(int i)
    {
        startNumber = i;
    }

    /**
     * Okrela liczb zwracanych pozycji.
     * @param i liczba pozycji
     */
    public void setCount(int i)
    {
        count = i;
    }

    /**
     * Przeglda elementy ekstensji ksiek.
     */
    protected void _execute()
    {
        extent = getPM().getExtent(Publication.class,true);
        Query query = getPM().newQuery(Publication.class, "true");
        query.setOrdering("title ascending");
        query.setCandidates(extent);
        Collection queryResult = (Collection)query.execute();
        Iterator iter = queryResult.iterator();
        int i = this.startNumber;
        while (i-- > 0 && iter.hasNext()) iter.next();
        i = this.count;

        ArrayList r = new ArrayList();
        while (i-- > 0 && iter.hasNext()) {
            Publication publication = (Publication)iter.next();
            r.add(new String(publication.toHTML(prefix)));
        }
        this.result = new String[r.size()];
        r.toArray(result);
        query.closeAll();
    }

    /**
     * Wersja dostpna w wierszu polece.
     */
    public static void main(String[] args) {
        new ListPublications().runCmdLine(args);
    }

    protected void run(String[] args) {
        setStartNumber(CmdLine.getIntVar("Pocztek:",0));
        setCount(CmdLine.getIntVar("Liczba:",10));
        execute();
        System.out.println("Result: ");
        String[] result = getResult();
        for (int i = 0; i < result.length; i++) {
            System.out.println(""+i+": "+result[i]);
        }
    }

    /**
     * The result is a list of Strings
     */
    public String[] getResult()
    {
        return result;
    }
    public int getCount()
    {
        return count;
    }
    public int getStartNumber()
    {
        return startNumber;
    }
    public String getPrefix()
    {
        return prefix;
    }
    public void setPrefix(String prefix)
    {
        this.prefix = prefix;
    }
}
