package com.corejdo.casestudy.usecase;

import java.io.FileInputStream;
import java.util.Properties;

import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

import com.corejdo.casestudy.model.Rights;
import com.corejdo.casestudy.model.User;
/**
 * Klasa ta dostarcza kontekstu wsplnego dla wszystkich klas reprezentujcych
 * przypadki uycia. Zawiera biec instancj PersistenceManager, singleton biblioteki,
 * sesj uytkownika i inne, wsplne informacje.
 *
 * W przypadku uycia serwletw, klasa ServletHelper zawiera wany kontekst
 * tak dugo jak istnieje sesja JSP/Servlet. W przypadku wersji uruchamianej z wiersza polece,
 * tworzony jest tylko pojedynczy kontekst.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public final class Context
{
    private PersistenceManager currentPersistenceManager;
    private static PersistenceManagerFactory pmf;

    // Atrybuty konteksu/sesji :
    User user;
    Rights userRights = new Rights();

    Context()
    {
    }
    /**
     * Tworzy lub zwraca fabryk JDO. Waciwoci fabryki
     * adowane s z pliku.
     */
    private PersistenceManagerFactory getPMF()
    {
	    if (pmf == null) {

	      String filename =
	        System.getProperty("jdo.properties");

	      if (filename == null) {

	        throw new JDOFatalUserException(
	          "Waciwo systemowa 'jdo.properties' nie zostaa zdefiniowana");
	      }

	      Properties properties = new Properties();

	      try {

	        FileInputStream file = 
	          new FileInputStream(filename);

	        properties.load(file);

	        file.close();

	        pmf = JDOHelper.getPersistenceManagerFactory(
	          properties);
	      }

	      catch (java.io.IOException e) {

	        throw new JDOFatalUserException(
	          "Bd podczas odczytu '" + filename + "'",
	          e);
	      }
	    }
	    return pmf;
    }

    /**
     * Tworzy lub zwraca instancj PersistenceManager.
     * Jeli z danym przypadkiem uycia zwizana jest instancja ServletHelper,
     * to moe ona dostarczy instancji PersistenceManager.
     */
    PersistenceManager getPM()
    {
        if (currentPersistenceManager == null) {
            currentPersistenceManager = getPMF().getPersistenceManager();
        }
        return currentPersistenceManager;
    }

    /**
     * Wywoywana przez warstw zarzdzania aplikacj.
     *
     * W przypadku uycia serwletw, metoda ta jest wywoywana na skutek przeterminowania sesji.
     * Wersja uruchamiana z wiersza polece wywouje t metod koczc swoje dziaanie.
     */
    void close()
    {
        if (currentPersistenceManager != null) {
            currentPersistenceManager.close();
            currentPersistenceManager = null;
        }
    }

    public boolean isLoggedIn()
    {
        return user != null;
    }
}
