package com.corejdo.casestudy.usecase;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.User;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Przypadek wprowadzenia ksiki do biblioteki.
 * Implementuje a wzorzec komonentu, ktry moe zosta wykorzystany przez JSP.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class AddBook
    extends AbstractUseCase
{
    /**
     * Wstawiana ksika. Dopki jest ulotna moemy
     * bezporednio pobiera i nadawa wartoci jej polom.
     */
    Book book = new Book();

    public AddBook()
    {
    }

    public void setISBN(String ISBN)
    {
        book.ISBN = ISBN;
    }
    public void setAuthor(String author)
    {
        book.author = author;
    }
    public void setCopyright(String copyright)
    {
        book.copyright = copyright;
    }
    public void setPublished(String published)
    {
        book.published = parseDate(published);
    }
    public void setFirstPublished(String firstPublished)
    {
        book.firstPublished = parseDate(firstPublished);
    }

    public void setTitle(String title)
    {
        book.title = title;
    }

    /**
     * Dodanie ksiki z wiersza polece.
     */
    public static void main(String[] args) {
        new AddBook().runCmdLine(args);
    }

    protected void run(String[] args) {
        setTitle(CmdLine.getStringVar("Tytu",""));
        setISBN(CmdLine.getStringVar("ISBN",""));
        setAuthor(CmdLine.getStringVar("Autor","Heiko Bobzin"));
        setCopyright(CmdLine.getStringVar("Copyright","(C) 2003 Prentice Hall"));
        String now = new Date().toString();
        setPublished(CmdLine.getStringVar("Data wydania",now));
        setFirstPublished(CmdLine.getStringVar("Data pierwszego wydania",now));
        execute();
    }

    private Date parseDate(String d)
    {
        try {
            return DateFormat.getInstance().parse(d);
        }
        catch (ParseException e)
        {
            throw new RuntimeException("Niedozwolona data: "+d);
        }
    }

    public boolean isAllowed()
    {
        return getContext().userRights.canManage();
    }

    protected void _execute()
    {
        // zupenie proste dziaanie:
        User user = getUser();
        book.insertedBy = user;
        getPM().makePersistent(book);
        book = new Book();
    }

    public String getFirstPublished()
    {
        return new Date().toString();
    }
    public String getPublished()
    {
        return new Date().toString();
    }
}
