DROP TABLE IF EXISTS CD;

CREATE TABLE CD (
    cdID	  INT		NOT NULL,
    artist        VARCHAR(50)	NOT NULL,
    title         VARCHAR(100)	NOT NULL,
    category	  VARCHAR(20),
    year	  INT,
    PRIMARY KEY ( cdID ),
    INDEX ( artist, title ),
    INDEX ( category ),
    INDEX ( year )
);		

DROP TABLE IF EXISTS Musician;

CREATE TABLE Musician (
    musicianID   INT            NOT NULL,
    lastName	 VARCHAR(30)    NOT NULL,
    firstName	 VARCHAR(30)	NOT NULL,
    nickname	 VARCHAR(40),
    PRIMARY KEY ( musicianID ),
    INDEX ( lastName, firstName )
);

DROP TABLE IF EXISTS Song;

CREATE TABLE Song (
    artist      VARCHAR(50)	NOT NULL,
    cd          VARCHAR(100)    NOT NULL,
    title       VARCHAR(100)    NOT NULL,
    UNIQUE INDEX ( artist, cd, title )
);

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'The Cure', 'Pornography', 'Alternative', 1983 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Garbage', 'Garbage', 'Grunge', 1995 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Public Image Limited', 'Compact Disc', 'Alternative', 1986 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Ramones', 'Mania', 'Punk', 1988 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Hole', 'Live Through This', 'Grunge', 1994 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Nine Inch Nails', 'The Downward Spiral', 'Industrial', 1994 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Wire', 'A Bell is a Cup Until It Is Struck', 'Alternative', 1989 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'Skinny Puppy', 'Last Rights', 'Industrial', 1992 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'The Sex Pistols', 'Never Mind the Bollocks, Here\'s the Sex Pistols', 'Punk', 1977 );

INSERT INTO CD ( artist, title, category, year )
VALUES ( 'The Mighty Lemon Drops', 'World Without End', 'Alternative', 1988 );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Reznor', 'Trent', NULL, 'Nine Inch Nails' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Smith', 'Robert', NULL, 'The Cure' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Love', 'Courtney', NULL, 'Hole' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Manson', 'shirley', NULL, 'Garbage' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Lydon', 'John', 'Johnny Rotten', 'The Sex Pistols,Public Image Limited' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Newman', 'Colin', NULL, 'Wire' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Hyman', 'Jeff', 'Joey Ramone', 'Ramones' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Gallup', 'Simon', NULL, 'The Cure' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Vig', 'Butch', NULL, 'Garbage' );

INSERT INTO Musician ( lastName, firstName, nickname, bands )
VALUES ( 'Ogilvie', 'Kevin', NULL, 'Ogre' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Supervixen' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Queer' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Only Happy When It Rains' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'As Heaven Is Wide' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Not My Idea' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'A Stroke of Luck' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Vow' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Stupid Girl' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'Dog New Tricks' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Garbage', 'Garbage', 'My Lover\'s Box' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Ramones', 'Mania', 'Rockaway Beach' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Ramones', 'Mania', 'Blitzkrieg Bop' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'The Cure', 'Pornography', 'The Figurehead' );

INSERT INTO Song ( artist, cd, title ) 
VALUES ( 'The Cure', 'Pornography', 'One Hundred Years' );

INSERT INTO Song ( artist, cd, title )
VALUES ( 'Public Image Limited', 'Compact Disc', 'Rise' );
