DROP TABLE IF EXISTS Customer;
DROP TABLE IF EXISTS Account;
DROP TABLE IF EXISTS Purchase_Order;
DROP TABLE IF EXISTS Item;
DROP TABLE IF EXISTS Product;

CREATE TABLE Customer
(
  customer_id mediumint(7) NOT NULL,
  name varchar(127),
  PRIMARY KEY (customer_id)
) TYPE=INNODB;

CREATE TABLE Account
(
  account_id mediumint(7) NOT NULL,
  customer_id mediumint(7) NOT NULL,
  balance mediumint(7),
  invoice_period mediumint(7),
  PRIMARY KEY (account_id),
  INDEX customer_idx(customer_id),
  FOREIGN KEY (customer_id) REFERENCES Customer(customer_id)
) TYPE=INNODB;

CREATE TABLE Purchase_Order
(
  order_id mediumint(7) NOT NULL,
  account_id mediumint(7) NOT NULL,
  delivery_date date,
  PRIMARY KEY (order_id),
  INDEX account_idx(account_id),
  FOREIGN KEY (account_id) REFERENCES Account(account_id)
) TYPE=INNODB;

CREATE TABLE Product
(
  product_id mediumint(7) NOT NULL,
  name varchar(127),
  description text,
  PRIMARY KEY (product_id)
) TYPE=INNODB;

CREATE TABLE Item
(
  item_id mediumint(7) NOT NULL,
  order_id mediumint(7) NOT NULL,
  product_id mediumint(7) NOT NULL,
  quantity mediumint(7),
  unit_price mediumint(7),
  PRIMARY KEY (item_id, order_id),
  INDEX order_idx(order_id),
  INDEX product_idx(product_id),
  FOREIGN KEY (order_id) REFERENCES Purchase_Order(order_id),
  FOREIGN KEY (product_id) REFERENCES Product(product_id)
) TYPE=INNODB;
