import junit.framework.TestCase;
import org.easymock.MockControl;

public class InvoiceTest extends TestCase {

  protected void setUp() throws Exception {
    super.setUp();

    // Tworzy obiekt pozorny na podstawie interfejsu ICustomer.
    //
    control = MockControl.createControl(ICustomer.class);
    customerMock = (ICustomer) control.getMock();

    // Przygotowuje klas bdc przedmiotem testu.
    //
    invoice = new Invoice(customerMock);
    invoice.setInvoiceAmount(200.0);
  }

  public final void testDiscount() {

    // Konfiguruje obiekt pozorny gotowy do przetestowania.
    //
    customerMock.discountRate();
    control.setReturnValue(10.0);

    // Wprowadza obiekt pozorny w stan aktywnoci.
    //
    control.replay();

    // Wykonuje test.
    //
    assertEquals(20.0, invoice.discount(), 0.0);

    // Upewnia si, e testowana klasa wywouje metod discountRate().
    //
    control.verify();
  }

  private MockControl control;
  private ICustomer   customerMock;
  private Invoice     invoice;

} // InvoiceTest
