package customer.admin.interfaces;

import java.util.Hashtable;
import javax.naming.InitialContext;
import junit.framework.TestCase;
import customer.domain.Customer;
import customer.factory.CustomerFactory;

public class CustomerAdminBeanTest extends TestCase {

  private CustomerAdminBean customerAdminBean = null;

  /**
   * Uzyskuje zdalny interfejs komponentu EJB Customer.
   */
  protected void setUp() throws Exception {
    super.setUp();

    Hashtable props = new Hashtable();

    props.put(InitialContext.INITIAL_CONTEXT_FACTORY,
              "weblogic.jndi.WLInitialContextFactory");

    props.put(InitialContext.PROVIDER_URL, "t3://localhost:7001");

    customerAdminBean = CustomerAdminBeanUtil.getHome(props).create();
  }

  /**
   * Oczekuje do klasy bdcej przedmiotem testu zadeklarowania egzemplarza Customer reprezentujcej klienta,
   * ktry nie dysponuje prawidowym kontem (metoda powinna wwczas zwrci warto false).
   *
   * @throws Exception
   */
  public final void testValidateAccount() throws Exception {

    Customer customer = CustomerFactory.getCustomer(1);

    assertFalse(customerAdminBean.validateAccount(customer));
  }

} // CustomerAdminBeanTest
