import java.util.Iterator;

import jess.Fact; 
import jess.RU;
import jess.Rete; 
import jess.Value; 

public class Airplane { 

  public static void main(String[] args) {

    try {
      // Tworzy egzemplarz mechanizmu reguowego.
      //
      Rete rete = new Rete();

      // Wczytuje z pliku gotowe reguy.
      //
      rete.executeCommand("(batch src/airplane_rules.clp)");

      rete.reset();

      // Dodaje cztery nowe fakty.
      // Pierwsze trzy fakty s dodawane do mechanizmu reguowego za porednictwem Javy.
      //
      Fact f1 = new Fact("jet", rete);
      f1.setSlotValue("name" ,
                      new Value("Boeing 737", RU.STRING));
      rete.assertFact(f1);

      Fact f2 = new Fact("prop", rete);
      f2.setSlotValue("name",
                      new Value("Cessna 172", RU.STRING));
      rete.assertFact(f2);

      Fact f3 = new Fact("prop", rete);
      f3.setSlotValue("name",
                      new Value("Tiger Moth", RU.STRING));
      rete.assertFact(f3);

      // Czwarty fakt jest dodawany przez wykonanie odpowiedniego wyraenia jzyka Jess.
      //
      rete.executeCommand(
        "(assert (jet (name \"Airbus 320\")))");

      // Uruchamia mechanizm reguowy.
      //
      rete.run();

      // List faktw mona wywietli programowo (z poziomu Javy).
      //
      System.out.println("\nFakty zdefiniowane w bazie wiedzy");

      Iterator iter = rete.listFacts();
      while (iter.hasNext()) {
        System.out.println("Fakt: " + iter.next());
      }

      // Do wywietlenia listy faktw mona te wykorzysta odpowiednie wyraenia Jessa.
      //
      System.out.println("\nFakty zwrcone przez Jessa");
      rete.executeCommand("(facts)");
    }
    catch (Exception e) {
      System.err.println(e);
    }
  }
}
