// CustomerServiceBean.java

package customer;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

/**
 * @ejb.bean
 *  name="CustomerService"
 *  jndi-name="CustomerServiceBean"
 *  type="Stateless"
 *
 * @ejb.resource-ref
 *  red-ref-name="jdbc/CustomerDataSource"
 *  res-type="javax.sql.Datasource"
 *  res-auth="Container"
 *
 * @weblogic.resource-description
 *  res-ref-name="jdbc/CustomerDataSource"
 *  jndi-name="CustomerDS"
 *
**/
public abstract class CustomerServiceBean
  implements SessionBean {

  /**
   * @ejb.interface-method tview-type="both"
   */
  public void createCustomer(CustomerV0 customer) {
  }

  /**
   * @ejb.interface-method tview-type="both"
   */
  public void updateCustomer(CustomerV0 customer) {
  }

  /**
   * @ejb.interface-method tview-type="both"
   */
  public CustomerV0 getCustomer(int customerID) {
    return new CustomerV0();
  }

} // CustomerServiceBean
