// ClassWizard.java

import java.io.FileWriter;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class ClassWizard {

  public static void main(String[] args) {

    // Ustawia nazw nowej klasy.
    //
    String className = "MyNewClass";

    try {
      // Inicjalizuje modu generowania kodu Velocity.
      //
      VelocityEngine engine = new VelocityEngine();
      engine.init();

      // Odczytuje szablon za porednictwem obiektu klasy VelocityEngine().
      //
      Template template = engine.getTemplate("wizard_template.vm");

      // Tworzy kontekst i dodaje potrzebne dane.
      //
      VelocityContext context = new VelocityContext();
      context.put("class", className);
      context.put("author", "Jan Kowalski");
      context.put("base", "MyBaseClass");
      context.put("add_ctor", new Boolean(false));
      context.put("add_main", new Boolean(true));

      // Generuje dane wyjciowe na bazie szablonu.
      //
      FileWriter writer = new FileWriter(className + ".java");

      template.merge(context, writer);

      writer.flush();
    } catch (Exception ex) {
      System.err.println(ex);
    }
  }

} // ClassWizard
