package hello;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.lcdui.*;

public class MyCanvas   extends Canvas implements CommandListener 
{
    private BluetoothConnection[] btConnections;
    private MultiplayerGame  midlet;
    private boolean isServer;
    
    private Game game = new Game(this);
    
    public  MyCanvas(BluetoothConnection[] btConns,
    MultiplayerGame _midlet,
    boolean _isServer ) 
    {
        midlet   = _midlet;
        isServer = _isServer;
        
        btConnections = btConns;
        
        for( int i=0; i<btConnections.length; i++ ) {
            ReceiveThread rt = new ReceiveThread(i);
            rt.start();
        }
        
        addCommand( new Command( "Wyjdz", Command.CANCEL, 1 ) );
        setCommandListener( this );
        
        if(game.initializeMultiplayer(isServer) == false)
        {
            return;
        }
        game.startGame();
    }
    
    public  MyCanvas(MultiplayerGame _midlet) 
    {
        midlet   = _midlet;
        
        addCommand( new Command( "Wyjdz", Command.CANCEL, 1 ) );
        setCommandListener( this );
        
        if(game.initialize() == false)
        {
            return;
        }
        game.startGame();
    }
    
    public BluetoothConnection getConnection(int index) {
        return btConnections[index];
    }
    
    public void paint( Graphics g ) 
    {
        game.draw(g);
    }
    
    protected void keyPressed(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        game.getHumanPlayer().gameActionPressed(gameAction);
    }
    
    protected void keyReleased(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        game.getHumanPlayer().gameActionReleased(gameAction);
    }
    
    protected void update()
    {   
        game.step();
    }
    
    public void commandAction( Command c, Displayable s ) {
        if( c.getCommandType() == Command.CANCEL ) {
            close();
            midlet.startUI();
        }
    }
    
    public void propagateMyKeybordState(int c)
    {
        if(true == isServer) 
        {
            for( int i=0; i<btConnections.length; i++ )
                sendIntegerToPeer(i,c );
        } 
        else 
        {
            sendIntegerToPeer(0,c);
        }       
    }  
    private synchronized void close() {
        for( int i=0; i<btConnections.length; i++ ) {
            btConnections[i].close();
        }
    }
    
    public void updateRemoteChar( int index, int c) {
        
        if(true == isServer) {
            for( int i=0; i<btConnections.length; i++ ) {
                if(i != index)
                    sendIntegerToPeer(i,(int)c);
            }
        }
        
        game.netUpdate(index,(int)c);
    }
    
    private void sendIntegerToPeer(int peerIndex, int c) 
    {
        BluetoothConnection connection = btConnections[peerIndex];
        try {
            connection.writeInt(c);
        }
        catch(IOException e) {
            connection.close();
        }
    }
    
    class ReceiveThread extends Thread 
    {
        private int index;
        
        public ReceiveThread(int i) {
            index = i;
        }
        
        public void run() {
            int inp;
            
            while( true ) {
                try {
                    inp = getConnection(index).readInt();
                } catch( IOException e ) {
                    getConnection(index).close();
                    return;
                }
                
                if( inp == -1 ) {
                    getConnection(index).close();
                    return;
                }
                updateRemoteChar( index, inp);
            }
        }
    }
}
