package hello;

import java.lang.Math.*;
import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class HumanPlayer extends Player
{
    float[] velocity  = new float[3];
    float   direction = 0.f;
    
    final float GRAVITY_ACCELERATION = -0.9f;
    final float DEADLY_Z_VELOCITY    = -4.f;
    final float SQUARED_MIN_SPEED    =  0.01f;
    final float VEL_DUMP_FACTOR      = 8.f;
    
    final int FLAG_SLOW_DOWN_PRESSED  = 1;
    final int FLAG_SPEED_UP_PRESSED   = 2;
    final int FLAG_TURN_LEFT_PRESSED  = 4;
    final int FLAG_TURN_RIGHT_PRESSED = 8;
    
    private int keyboardState = 0;
    
    private boolean networkPlayer = false;
    private boolean networkGame = false;
    
    Game game = null;
    
    public HumanPlayer(Mesh mesh, Game gameInstance, boolean _networkPlayer, boolean _networkGame)
    {
        super(mesh);
        
        game = gameInstance;
        networkPlayer = _networkPlayer;
        networkGame = _networkGame;
        mesh.setScope(4);
    }
    
    public int getLaps() { return iNumLaps; }   
    
    public void netUpdate(int netKeyboardState)
    {
        keyboardState = netKeyboardState;
        update(0.4f);
    }
    
    public void update(float deltaTime)
    {   
        if((iNumLaps == 3) || (isActive == false))
            return;
        
        int turn = 0;
        int accellerate = 0;
        
        if((keyboardState&FLAG_SLOW_DOWN_PRESSED)!=0)  accellerate = -1;
        if((keyboardState&FLAG_SPEED_UP_PRESSED)!=0)   accellerate = 1;
        if((keyboardState&FLAG_TURN_LEFT_PRESSED)!=0)  turn = 1;
        if((keyboardState&FLAG_TURN_RIGHT_PRESSED)!=0) turn = -1;
        
        float[] acceleration = new float[2];
        
        acceleration[0]=(float)Math.cos(direction)*(float)accellerate;
        acceleration[1]=(float)Math.sin(direction)*(float)accellerate;
        
        float x = position[0] + velocity[0]*deltaTime + (acceleration[0]*deltaTime*deltaTime)/2.f;
        float y = position[1] + velocity[1]*deltaTime + (acceleration[1]*deltaTime*deltaTime)/2.f;
        
        float vx = velocity[0] + acceleration[0]*deltaTime;
        float vy = velocity[1] + acceleration[1]*deltaTime;
        
        boolean passedStartLine = game.getTrack().checkPassedStartLine(
        position[0],position[1],position[2],x,y,position[2]);
        
        if(passedStartLine == true)
        {        
            ++iNumLaps;
            if(iNumLaps == 3)
                game.reportPlayerOnFinish(this);
        }
        
        position[0] = x;
        position[1] = y;
        
        if((vx*vx + vy*vy) > SQUARED_MIN_SPEED)
        {
            velocity[0] = vx - vx/VEL_DUMP_FACTOR;
            velocity[1] = vy - vy/VEL_DUMP_FACTOR;
        }
        else
        {
            velocity[0] = velocity[1] = 0;
        }
        
        if(turn == 1)
            direction += 0.1;
        else if(turn==-1)
            direction -= 0.1;
        
        playerMesh.setTranslation(x,y,position[2]);
        playerMesh.setOrientation((float)Math.toDegrees(direction),0,0,1);
        
        updateHeight(deltaTime);
        
        if((networkPlayer == false) && (networkGame == true))
            game.propagateHumanPlayerKeybordState(keyboardState);
    }
    
    private void updateHeight(float deltaTime)
    {
        if(velocity[2] < DEADLY_Z_VELOCITY)
        {
            isActive=false;
        }
        
        if(game.getTrack().isGroundBelow(position) == false)
        {
            position[2] += velocity[2]*deltaTime + 
            (GRAVITY_ACCELERATION*deltaTime*deltaTime)/2.f;
            velocity[2] += GRAVITY_ACCELERATION * deltaTime;        
        }
        else
        {
            float distance = game.getTrack().getDistanceToGround(position);
            velocity[2] = 0;
            float distanceDelta = distance - PREFERED_GROUND_DIST;
            position[2] -= distanceDelta/4.f;       
        }
    }
    
    public void gameActionPressed(int gameAction)
    {
        switch(gameAction)
        {
            case Canvas.DOWN:  keyboardState|=FLAG_SLOW_DOWN_PRESSED;  break;
            case Canvas.UP:    keyboardState|=FLAG_SPEED_UP_PRESSED;   break;
            case Canvas.LEFT:  keyboardState|=FLAG_TURN_LEFT_PRESSED;  break;
            case Canvas.RIGHT: keyboardState|=FLAG_TURN_RIGHT_PRESSED; break;
        }
    }
    
    public void gameActionReleased(int gameAction)
    {
        switch(gameAction)
        {
            case Canvas.DOWN:  keyboardState&=~FLAG_SLOW_DOWN_PRESSED;  break;
            case Canvas.UP:    keyboardState&=~FLAG_SPEED_UP_PRESSED;   break;
            case Canvas.LEFT:  keyboardState&=~FLAG_TURN_LEFT_PRESSED;  break;
            case Canvas.RIGHT: keyboardState&=~FLAG_TURN_RIGHT_PRESSED; break;
        }
    }
}