package hello;

import javax.microedition.lcdui.*;

public class GameModeSelect extends List implements CommandListener 
{    
    private MultiplayerGame midlet;
    
    public GameModeSelect(MultiplayerGame _midlet) 
    {        
        super( "Wybierz tryb:", List.IMPLICIT );      
        midlet = _midlet;
        
        append( "Single player", null );
        append( "Multiplayer", null );
        addCommand( new Command( "Wybierz", Command.OK, 1 ) );
        addCommand( new Command( "Wyjdz", Command.EXIT, 1 ) );
        setCommandListener( this );
    }
    
    public void commandAction( Command c, Displayable d ) {
        if( c.equals(List.SELECT_COMMAND) || (c.getCommandType() == Command.OK) ) {
            int i = getSelectedIndex();
            String s = getString( i );
            
            if( s.equals( "Single player" ) ) {
                midlet.getMidletDisplay().setCurrent(new MyCanvas(midlet));
            }
            if( s.equals( "Multiplayer" ) )
            {
                midlet.getMidletDisplay().setCurrent(new ClientServerSelect(midlet));
            }        
        } else if( c.getCommandType() == Command.EXIT ) {
            midlet.Exit();
        }
    }
}