package hello;

import javax.microedition.lcdui.*;

public class ClientServerSelect extends List implements CommandListener 
{    
    private MultiplayerGame midlet;
    
    public ClientServerSelect(MultiplayerGame _midlet) 
    {        
        super( "Wybierz role:", List.IMPLICIT );      
        midlet = _midlet;
        
        append( "Dolacz do gry", null );
        append( "Stworz gre", null );
        addCommand( new Command( "Wybierz", Command.OK, 1 ) );
        addCommand( new Command( "Wyjdz", Command.EXIT, 1 ) );
        setCommandListener( this );
    }
    
    public void commandAction( Command c, Displayable d ) {
        if( c.equals(List.SELECT_COMMAND) || (c.getCommandType() == Command.OK) ) {
            int i = getSelectedIndex();
            String s = getString( i );
            
            if( s.equals( "Dolacz do gry" ) ) {               
                new ServerConnectionScreen(midlet);                
            }
            if( s.equals( "Stworz gre" ) )
            {
                new ClientConnectionScreen(midlet);                
            }        
        } else if( c.getCommandType() == Command.EXIT ) {
            midlet.Exit();
        }
    }
}
