package hello;

import javax.microedition.m3g.*;
import javax.microedition.lcdui.*;
import java.util.*;
import java.lang.*;

public class Game implements Runnable
{   
    final int GAME_STATE_COUNT_DOWN = 1;
    final int GAME_STATE_RACE = 2;
    final int GAME_STATE_SHOW_RESULTS = 3;
    
    final int NUM_AI_PLAYERS = 4;
    
    private int currentGameState = GAME_STATE_COUNT_DOWN;
    
    private MyCanvas gameCanvas = null;
    
    private HumanPlayer humanPlayer = null;
    private Vector aiPlayers = new Vector();
    private World world = null;    
    private Track track = new Track();
    
    private boolean isAlive = false;
    private int threadSleep = 1000;
    
    private int countDownCntr = 3;
    private int timeFromStart = 0;
    
    private int screenWidth;
    private int screenHeight;
    
    private Thread heartBeatThread = null;
    
    private Vector  orderOnFinish = new Vector();
    private float[] timesOnFinish = new float[NUM_AI_PLAYERS+1];
    
    public Game(MyCanvas canvas)
    {
        gameCanvas = canvas;
        screenWidth = canvas.getWidth();
        screenHeight = canvas.getHeight();      
    }
    
    public HumanPlayer getHumanPlayer() { return humanPlayer; }
    
    public Track getTrack() { return track; }
    
    public boolean initialize()
    {
        Object3D[] roots = null;
        
        try
        {
            roots = Loader.load("/scene_prototype.m3g");
        }
        catch(Exception e)
        {
            return false;
        }
        
        world = (World)roots[0];
        
        track.initialize(world);
        
        Mesh playerMesh = (Mesh)world.find(1);
        if(playerMesh == null)
        {
            System.out.println("no match!");
        }
        else
        {
            humanPlayer = new HumanPlayer(playerMesh, this, 0.f, new float[] {0,0,0});
            humanPlayer.setName("Gracz");
        }      
        
        Random rnd = new Random();      
        for(int i=0 ; i<NUM_AI_PLAYERS ; i++)
        {
            playerMesh = (Mesh)world.find(50+i);
            if(playerMesh == null)
            {
                System.out.println("no ai player found - id=:" + i);
            }
            else
            {
                AIPlayer aiPlayer = new AIPlayer(playerMesh, this, rnd.nextFloat()/4.f+0.1f);
                aiPlayer.setName("Komputer " + (i+1));
                aiPlayers.addElement(aiPlayer);
            }
        }
        
        return true;
    }
    
    public void reportPlayerOnFinish(Player player)
    {
        int numPlayersOnFinish = orderOnFinish.size();
        timesOnFinish[numPlayersOnFinish] = timeFromStart;
        orderOnFinish.addElement(player);
        
        if((orderOnFinish.size() == NUM_AI_PLAYERS+1) ||
            (orderOnFinish.size() == NUM_AI_PLAYERS    && 
        humanPlayer.isActive() == false))
        {
            currentGameState = GAME_STATE_SHOW_RESULTS;
        }
    }
    
    public void startGame()
    {
        heartBeatThread = new Thread(this);
        heartBeatThread.start();
    }
    
    public void stopGame()
    {
        isAlive = false;
    }
    
    public void step()
    {
        switch(currentGameState)
        {
            case GAME_STATE_COUNT_DOWN:
            StepCountDown();
            break;
            case GAME_STATE_RACE:
            StepRace();
            break;
            case GAME_STATE_SHOW_RESULTS:
            StepShowResults();
            break;
        }
    }
    
    public void draw(Graphics g)
    {
        switch(currentGameState)
        {
            case GAME_STATE_COUNT_DOWN:
            DrawCountDown(g);
            break;
            case GAME_STATE_RACE:
            DrawRace(g);
            break;
            case GAME_STATE_SHOW_RESULTS:
            DrawShowResults(g);
            break;
        }
    }
    
    private void StepCountDown()
    {
        if(--countDownCntr < 0)
        {
            currentGameState = GAME_STATE_RACE;
            threadSleep = 100;
        }
        
        gameCanvas.repaint();
        gameCanvas.serviceRepaints();
    }
    
    private void StepRace()
    {
        timeFromStart += 100;
        
        humanPlayer.update(0.4f);
        
        for(int i = 0 ; i<aiPlayers.size() ; i++)
        {
            AIPlayer aiPlayer = (AIPlayer)aiPlayers.elementAt(i);
            aiPlayer.update(0.4f);
        }
        
        gameCanvas.repaint();
        gameCanvas.serviceRepaints();
    }
    
    private void StepShowResults()
    {
        gameCanvas.repaint();
        gameCanvas.serviceRepaints();
    }
    
    private void DrawCountDown(Graphics g)
    {
        g.setColor(100,60,200);
        g.fillRect(0,0,screenWidth, screenHeight);      
        g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_BOLD,Font.SIZE_LARGE));      
        g.setColor(255,100,100);
        g.drawString("Uwaga!",screenWidth/2,screenHeight/3,Graphics.TOP | Graphics.HCENTER);
        g.setColor(255,255,255);
        g.drawString(new Integer(countDownCntr).toString(),screenWidth/2,screenHeight/2,0);
    }
    
    private void DrawRace(Graphics g)
    {
        Graphics3D g3d = Graphics3D.getInstance();
        
        g3d.bindTarget(g);
        g3d.render(world);
        g3d.releaseTarget();
        
        String interfaceString = "Okrazenie: " + humanPlayer.getLaps() +
        " Czas: " + (float)timeFromStart/1000;
        g.setColor(255,205,170);
        g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_BOLD,Font.SIZE_LARGE));
        g.drawString(interfaceString,0,0,0);
    }
    
    private void DrawShowResults(Graphics g)
    {
        String congratulationText = null;
        
        int positionOnFinish = orderOnFinish.indexOf(humanPlayer);
        switch(positionOnFinish)
        {
            case -1: congratulationText = "Przegrales! Sprobuj ponownie!";    break;
            case  0: congratulationText = "Gratulacje! Zwyciezyles!";    break;
            case  4: congratulationText = "Niezle! Potrenuj jeszcze!";         break;
            default: congratulationText = "Bardzo dobrze! Sprobuj ponownie!";  break;
        }
        
        g.setColor(120,120,255);
        g.fillRect(0,0,screenWidth, screenHeight);
        g.setColor(255,200,255);
        g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_BOLD | Font.STYLE_ITALIC,Font.SIZE_LARGE));
        g.drawString(congratulationText,screenWidth/2,screenHeight/16,Graphics.TOP | Graphics.HCENTER);      
        
        g.setColor(170,255,255);            
        g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_ITALIC,Font.SIZE_MEDIUM));
        g.drawString("Wyniki:",0,screenHeight/6,0);
        
        g.setFont(Font.getFont(Font.FACE_SYSTEM,0,Font.SIZE_MEDIUM));
        for(int i=0 ; i<orderOnFinish.size() ; i++)
        {
            int colorGradient = i+1;
            g.setColor(255/colorGradient,255/colorGradient,255/colorGradient);
            int verticalPosition = screenHeight/4 + i*12;
            
            Player player = (Player)orderOnFinish.elementAt(i);
            String result = i+1 + ". " + player.getName();
            result += " - " + timesOnFinish[i]/1000;
            g.drawString(result,10, verticalPosition, 0);
        }
    }
    
    public void run()
    {
        isAlive = true;
        while(isAlive==true)
        {
            try 
            {
                Thread.sleep(threadSleep);
                step();
            }
            catch(Exception e)
            {
                isAlive = false;
                System.out.println("Exception on update thread");
            }
        } 
        System.out.println("Leaving update thread!");
    }
}