package hello;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.*;
import javax.microedition.lcdui.*;

public class SearchResult extends List implements CommandListener{
    
    private BluetoothExample midlet;
    private Vector serviceRecordsFound;
    Vector selectedRecords = new Vector();
    
    public SearchResult(BluetoothExample _midlet, Vector serviceRecords) {
        super( "Wybierz graczy:", List.MULTIPLE);
        
        midlet = _midlet;
        serviceRecordsFound = serviceRecords;
        
        addCommand(new Command("Start gry", Command.OK,1));
        addCommand(new Command("Powrot", Command.EXIT,1));
        addCommand(new Command( "Szukaj", Command.SCREEN,1));
        setCommandListener( this );
        
        addFoundServicesToSelectionList();
        midlet.getMidletDisplay().setCurrent(this);
    }
    
    private void addFoundServicesToSelectionList() 
    {    
        for(int i=0 ; i<serviceRecordsFound.size() ; i++) {
            ServiceRecord sr = (ServiceRecord)serviceRecordsFound.elementAt(i);
            RemoteDevice rd = sr.getHostDevice();
            try
            {
                append( rd.getFriendlyName(true), null );
            }
            catch(IOException e) {}
        }
    }
    
    private void MakeConnections() 
    {        
        for(int i=0 ; i<serviceRecordsFound.size() ; i++) {
            if(true == isSelected(i)) {
                selectedRecords.addElement(serviceRecordsFound.elementAt(i));
            }
        }
        
        MakeConnectionsThread t = new MakeConnectionsThread();
        t.start();
    }
    
    public void commandAction( Command c, Displayable s ) {
        int command = c.getCommandType();
        if(command == Command.OK)
        {
            MakeConnections();
        }
        else if(command == Command.EXIT)
        {
            midlet.startUI();
        }
        else if(command == Command.SCREEN)
        {
            new ClientConnectionScreen(midlet);
        }
    }
    
    public void devicesConnected(BluetoothConnection[] connections) {        
        NumberCanvas nc = new NumberCanvas(connections, midlet,true );
        midlet.getMidletDisplay().setCurrent( nc );
    }
    
    private class MakeConnectionsThread extends Thread 
    {    
        public void run() {
            BluetoothConnection[] btConnections = new BluetoothConnection[selectedRecords.size()];
            
            try {
                for( int i=0; i<selectedRecords.size(); i++ ) { 
                    ServiceRecord sr = (ServiceRecord)selectedRecords.elementAt(i);
                    String connectionUrl = sr.getConnectionURL( ServiceRecord.NOAUTHENTICATE_NOENCRYPT,false);
                    
                    String rname="";
                    try
                    {
                        rname = sr.getHostDevice().getFriendlyName(true);
                    }
                    catch(IOException e) {}
                    
                    String localName = LocalDevice.getLocalDevice().getFriendlyName();
                    btConnections[i] = new BluetoothConnection(connectionUrl, localName, rname );                    
                }
            } catch(IOException e) {
                System.out.println("Error when making connection ...");
            }
            
            devicesConnected(btConnections);
        }
    }    
}
