package hello;
import java.util.Vector;
import javax.bluetooth.*;
import javax.microedition.io.*;
import javax.microedition.lcdui.*;

public class ClientConnectionScreen implements CommandListener, DiscoveryListener
{    
    private Vector devicesInVicinity = new Vector();
    private Vector serviceRecords = new Vector();
    
    private static final int MAJOR_DEVICE_CLASS_PHONE = 0x0200;
    private final String serviceUUID = "7B801165D7A711DB9705005056C00008";
    
    BluetoothExample midlet;
    private DiscoveryAgent discoveryAgent;
    
    public ClientConnectionScreen(BluetoothExample _midlet) {
        
        midlet = _midlet;
        
        TextBox tbMain = new TextBox("Prosze czekac", "Poszukuje graczy", 50, 0);
        midlet.getMidletDisplay().setCurrent(tbMain);
        
        try {
            discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
        } 
        catch(Exception e) 
        {
            String message = "Error trying to get local device properties: " + e.getMessage();
            System.out.println(message);
        }
        
        try
        {
            discoveryAgent.startInquiry( DiscoveryAgent.LIAC, this);
        }
        catch(BluetoothStateException e)
        {
            System.out.println("Inquiry exception");
        }
    }
    
    
    public void deviceDiscovered(RemoteDevice btDevice,DeviceClass cod )
    {
        if(cod.getMajorDeviceClass() == MAJOR_DEVICE_CLASS_PHONE ) {
            if(false == devicesInVicinity.contains( btDevice )) {
                devicesInVicinity.addElement( btDevice );
            }
        }
    }
    
    public void inquiryCompleted( int discType ) {
        UUID[] serviceUidsToSearch = new UUID[] {
        new UUID(serviceUUID,false)};
        
        if( discType == INQUIRY_COMPLETED ) 
        {       
            if(devicesInVicinity.size()!=0) 
            {     
                for(int i=0 ; i<devicesInVicinity.size() ; i++) 
                {
                    try {
                        discoveryAgent.searchServices(null, serviceUidsToSearch,
                        (RemoteDevice)devicesInVicinity.elementAt(i),this);
                    }
                    catch(BluetoothStateException e){
                        System.out.println("Services Exception");
                    }               
                }
            }           
            else
            {
                midlet.startUI();
            }
        }       
    }
    
    public void servicesDiscovered(int transID,ServiceRecord[] servRec) {
        serviceRecords.addElement(servRec[0]);
    }
    
    public void serviceSearchCompleted( int transID, int respCode ) {
        new SearchResult(midlet, serviceRecords);
    }
    
    public void commandAction(Command c, Displayable s) {
        if(c.getCommandType() == Command.CANCEL) { 
            midlet.startUI();
        }
    }
    
}
