package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;
//import java.util.*;


public class MyCanvas extends Canvas {
    
    private Graphics3D      g3d;
    private World           world;    
    private Mesh            selectedMesh = null;
    private Appearance      selectedMeshAppearance = null;
    
    private Image pointerImage = null;
    
    int xPos;
    int yPos;
    int xMove=0;
    int yMove=0;
    
    public MyCanvas() 
    {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    // exit the MIDlet
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }       
    }
    
    private void init() throws Exception  
    { 
        addCommand(new Command("Koniec", Command.EXIT, 1));
        
        g3d = Graphics3D.getInstance();
        pointerImage = Image.createImage("/pointer.png");
        
        Object3D[] roots = Loader.load("/world.m3g");
        world = (World)roots[0];
        
        xPos = getWidth()/2;  
        yPos = getHeight()/2;
    }
    
    protected void keyPressed(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        
        switch(gameAction)
        {
            case UP:    yMove=-1;   break;
            case DOWN:  yMove=+1;   break;
            case LEFT:  xMove=-1;   break;
            case RIGHT: xMove=+1;   break;
            case FIRE:  pickMesh(); break;
        }
    }
    
    protected void keyReleased(int keyCode)
    {
        int gameAction = getGameAction(keyCode);
        
        switch(gameAction)
        {
            case UP:   case DOWN:  yMove=0; break;
            case LEFT: case RIGHT: xMove=0; break;
        }
    }
    
    protected void pickMesh()
    {
        RayIntersection ray = new RayIntersection();
        float p1, p2;
        
        p1 = (float)xPos / (float)getWidth();
        p2 = (float)yPos / (float)getHeight();
        
        boolean hit = world.pick(-1, p1, p2, world.getActiveCamera(), ray);
        if(hit==true)
        {
            if(selectedMesh!=null)
                selectedMesh.setAppearance(0,selectedMeshAppearance);
            
            selectedMesh = (Mesh)ray.getIntersected();
            selectedMeshAppearance = selectedMesh.getAppearance(0);
            selectedMesh.setAppearance(0,new Appearance());
        }
    }
    
    protected void paint(Graphics g) 
    {    
        xPos+=xMove;
        yPos+=yMove;
        
        g3d.bindTarget(g);
        g3d.render(world);
        g3d.releaseTarget();
        
        g.drawImage(pointerImage, xPos, yPos, 0);
    }
}