package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;
import java.util.*;


public class MyCanvas extends Canvas {
    
    private Graphics3D      g3d;
    private Camera          camera;
    private World           world;    
    private Background      background;
    private int appTime = 0;
    Timer iTimer = new Timer();
    
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }       
    }
    
    private void init() throws Exception  
    {
        KeyframeSequence backgroundAnim;
        AnimationTrack animTrack;
        
        addCommand(new Command("Koniec", Command.EXIT, 1));
        
        g3d = Graphics3D.getInstance();
        world = new World();
        
        camera = new Camera();
        camera.setPerspective(30.0f,
              (float)getWidth()/(float)getHeight(),
              1.0f,1000.0f );
        
        background = new Background();
        
        world.addChild(camera);                                 
        world.setActiveCamera(camera);         
        world.setBackground(background);
        
        backgroundAnim = new KeyframeSequence(3,3,KeyframeSequence.LINEAR);
        backgroundAnim.setKeyframe(0, 0,  new float[] {1.f,0,0});
        backgroundAnim.setKeyframe(1, 50, new float[] {0,0,1.f});
        backgroundAnim.setKeyframe(2, 100,new float[] {0,1.f,0});
        backgroundAnim.setDuration(100);
        
        animTrack = new AnimationTrack(backgroundAnim, AnimationTrack.COLOR);
        background.addAnimationTrack(animTrack);
        animTrack.setController(new AnimationController());
        
        iTimer.schedule( new MyTimerTask(), 0, 50 );
    }
    
    protected void paint(Graphics g) 
    {    
        world.animate(++appTime%100);
        
        g3d.bindTarget(g);
        g3d.render(world);
        g3d.releaseTarget();
    }
    
    class MyTimerTask extends TimerTask {
        public void run() {
            repaint();
        }
    }
}
