package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class MyCanvas extends Canvas {
    
    private Graphics3D      iG3D;
    private Camera          iCamera;    
    private Light           iLight;    
    private Light           iAmbientLight;
    private VertexBuffer    iVb;
    private IndexBuffer     iIb;       
    private Appearance      iAppearance = new Appearance();    
    private Material        iMaterial = new Material();    
    private PolygonMode     iPolygonMode = new PolygonMode();
    private float           iAngle = 0.0f;
    
    private final int numSegments = 8;
    private final double radius = 5;
    private final double height = 6;
    
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {                    
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private void init() throws Exception  
    {
        addCommand(new Command("Exit", Command.EXIT, 1));        
        iG3D = Graphics3D.getInstance();        
        iCamera = new Camera();
        iCamera.setPerspective( 60.0f,
        (float)getWidth() / (float)getHeight(),
        1.0f, 1000.0f );                
        iLight = new Light();
        iLight.setColor(0xffffff);
        iLight.setIntensity(1.25f);
        
        iAmbientLight = new Light();
        iAmbientLight.setMode(Light.AMBIENT);
        iAmbientLight.setColor(0xff202080);
        iAmbientLight.setIntensity(1.0f);
        
        short[] vert = new short[numSegments*2*3];
        byte[] norm = new byte[numSegments*2*3];
        
        for(int i=0 ; i<numSegments ; i++)
        {
            double angle = ((Math.PI * 2.0)/numSegments) * i;
            
            double x = radius * Math.sin(angle);
            double y = radius * Math.cos(angle);
            
            vert[3*i]     = vert[3*(i + numSegments)]     = (short)x;
            vert[(3*i)+1] = vert[3*(i + numSegments)+1]   = (short)y;
            vert[(3*i)+2] = (short)(-height);
            vert[3*(i+numSegments)+2] = (short)(height);
            
            norm[3*i]     = norm[3*(i + numSegments)]     = (byte)x;
            norm[(3*i)+1] = norm[3*(i + numSegments)+1]   = (byte)y;
            norm[(3*i)+2] = norm[3*(i+numSegments)+2] = 0;                         
        }
        
        VertexArray vertArray = new VertexArray(vert.length / 3, 3, 2);
        vertArray.set(0, vert.length/3, vert);
        VertexArray normArray = new VertexArray(norm.length / 3, 3, 1);
        normArray.set(0, norm.length/3, norm);
        
        VertexBuffer vb = iVb = new VertexBuffer();
        vb.setPositions(vertArray, 1.0f, null);
        vb.setNormals(normArray);
        vb.setDefaultColor(0x0000ff00);
        iIb = new TriangleStripArray(
           new int[] {0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15,0,8},
           new int[] {18} );
        
        iPolygonMode.setCulling(PolygonMode.CULL_NONE);
        iAppearance.setPolygonMode(iPolygonMode);
        iAppearance.setMaterial(iMaterial);
        iMaterial.setColor(Material.DIFFUSE, 0xFFFF80a0);
        iMaterial.setColor(Material.SPECULAR,0xFF8050c0);
        iMaterial.setColor(Material.AMBIENT, 0xFF404040);
        iMaterial.setShininess(100.0f);
    }    
    
    protected void paint(Graphics g) 
    {
        iG3D.bindTarget(g, true, 0);
        iG3D.clear(null);
        
        Transform transform = new Transform();
        transform.postRotate(++iAngle, 1.0f, 1.0f, 1.0f);
        transform.postTranslate(0.0f, 0.0f, 30.0f);        
        iG3D.setCamera(iCamera, transform);                     
        
        iG3D.resetLights();
        iG3D.addLight(iLight, transform);        
        iG3D.addLight(iAmbientLight,null);
        
        iG3D.render(iVb, iIb, iAppearance, null);
        
        iG3D.releaseTarget();
    }
}

