package hello;

import javax.microedition.lcdui.*;
import javax.microedition.m3g.*;

public class MyCanvas extends Canvas 
{
    private Graphics3D      iG3D;
    private Camera          iCamera;    
    private VertexBuffer    iVb;
    private IndexBuffer     iIb;       
    private Appearance      iAppearance = new Appearance();
    private PolygonMode     iPolygonMode = new PolygonMode();
    private float           iAngle = 0.0f;
    
    private final int numSegments = 8;
    private final double radius = 5;
    private final double height = 6;
   
    public MyCanvas() {
        setCommandListener(new CommandListener()  {
            public void commandAction(Command c, Displayable d) {
                if (c.getCommandType() == Command.EXIT) {                    
                    HelloMidlet.quitApp();
                }
            }
        });
        try {
            init();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private void initGeometry()
    {
        short[] vert = new short[numSegments*2*3];;
        
        for(int i=0 ; i<numSegments ; i++)
        {
            double angle = ((Math.PI * 2.0)/numSegments) * i;
            
            double x = radius * Math.sin(angle);
            double y = radius * Math.cos(angle);
            
            vert[3*i]     = vert[3*(i + numSegments)]     = (short)x;
            vert[(3*i)+1] = vert[3*(i + numSegments)+1]   = (short)y;
            vert[(3*i)+2] = (short)(-height);
            vert[3*(i+numSegments)+2] = (short)(height);
        }
        
        VertexArray vertArray = new VertexArray(vert.length/3, 3, 2);
        vertArray.set(0, vert.length/3, vert);                     
        VertexBuffer vb = iVb = new VertexBuffer();
        vb.setPositions(vertArray, 1.0f, null);
        vb.setDefaultColor(0x0000ff00);
        
        iIb = new TriangleStripArray(
                new int[] {0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15,0,8},
                new int[] {18} );
        
    }
    
    private void init() throws Exception  {
        
        addCommand(new Command("Exit", Command.EXIT, 1));        
        
        iG3D = Graphics3D.getInstance();        
        iCamera = new Camera();
        iCamera.setPerspective( 60.0f,
                (float)getWidth() / (float)getHeight(),
                1.0f, 1000.0f );                
        
        iPolygonMode.setCulling(PolygonMode.CULL_NONE);
        iAppearance.setPolygonMode(iPolygonMode);
        
        initGeometry();
    }    
    
    protected void paint(Graphics g) {
        
        iG3D.bindTarget(g, true, 0);
        iG3D.clear(null);
        Transform transform = new Transform();
        transform.postRotate(++iAngle, 1.0f, 1.0f, 1.0f);  
        transform.postTranslate(0.0f, 0.0f, 30.0f);        
        iG3D.setCamera(iCamera, transform);                                               
        iG3D.render(iVb, iIb, iAppearance, null);
        iG3D.releaseTarget();
    }
}