package mypackage;

import javax.microedition.lcdui.*;
import java.util.*;
import java.lang.Math.*;

public class Raycaster extends Canvas {
    
    public static final int screenHeight = 200;    // rozdzielczosc ekranu y
    public static final int screenWidth  = 180;    // rozdzielczosc ekranu x
    public static final int screenHalfHeight = 50;    // rozdzielczosc ekranu y
    public static final int maxDistance = 40;
    
    private Player player;

    private int halfViewAngle = 45;

    private void initialize() {
        player = new Player(this);
        player.setPos(2.5f,1.50f);
    }
    
    public int getMapPoint(int x, int y) {
        return worldMap[x][y];
    }
    
    private  int worldMap[][] = new int[][] {
        {4,1,1,1,1,1,1,1,1,1},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,0,0,0,0,0,0,0,0,2},
        {4,3,3,3,3,3,3,3,3,3}};
        
        private int arrX[] = new int[] { 1,-1,-1, 1 };
	private int arrY[] = new int[] { 1, 1,-1,-1 };
	
        public Raycaster() {
            initialize();
        }
        
        public void paint(Graphics g) 
	{
	    int playerDirection = player.getAngle()%360;
            if(playerDirection<0) 
               playerDirection+=360;
	    
	    g.fillRect(0,0,screenWidth,screenHeight);
	    
            Render(g,playerDirection, player.getPosX(), player.getPosY());
        }
        
	private double Cos(double angle) { return Math.cos(Math.toRadians(angle)); }
	private double Sin(double angle) { return Math.sin(Math.toRadians(angle)); }

        public void Render(Graphics g, int playerDirection, double playerX, double playerY) {
                                     
            int x=0;                       
    
            for(int rayAngle = playerDirection - halfViewAngle ;
                    rayAngle < playerDirection + halfViewAngle ;
                    rayAngle++) 
            {
                int ceilPosX = (int)playerX;
                int ceilPosY = (int)playerY;
		    
                double a = 1.0 - (playerX - ceilPosX);
                double b = 1.0 - (playerY - ceilPosY);
                
                double dk = Math.abs(1.0 / Cos(rayAngle));
                double dl = Math.abs(1.0 / Sin(rayAngle));
                
                double k = a * dk;
                double l = b * dl;
                
                int index = (rayAngle % 360) / 90;
		int stepX = arrX[index];
		int stepY = arrY[index];

                double distance = 0.f;
                boolean hit = false;
		int leftHit = 1;
		
                while(false == hit) {
                    if(k>l) {
                        ceilPosY += stepY;
                        if(0 != worldMap[ceilPosX][ceilPosY]) {
                            hit = true;
                            distance = l;
			 
                        } else {
                            l += dl;
                        }
                    } else {
                        ceilPosX += stepX;
                        if(0 != worldMap[ceilPosX][ceilPosY]) {
                            hit = true;
                            distance = k;
			 
			    leftHit=2;
                        } else {
                            k += dk;
                        }
                    }
                }
  
		
		g.setColor(160/leftHit,160/leftHit,255/leftHit);
           
		distance*=Cos(playerDirection-rayAngle); //fish eye                
		distance = 30/distance; //maxDistance-distance%maxDistance;

                g.drawLine(x,screenHalfHeight - (int)distance, 
		           x,screenHalfHeight + (int)distance);
                x++;
            }
        }

        public void keyPressed(int keyCode) {
            int action = getGameAction(keyCode);
            switch(action) {
                case Canvas.LEFT:
                    player.RotateLeft();
                    break;
                case Canvas.RIGHT:
                    player.RotateRight();
                    break;
                case Canvas.UP:
                    player.MoveForward();
                    break;
                case Canvas.DOWN:
                    player.MoveBackward();
                    break;
            }
            repaint();
            serviceRepaints();
        }
        
        
        
}
