package hello;

import javax.microedition.lcdui.*;

public class MyCanvas extends Canvas implements CommandListener{
   
   
    HelloMidlet midlet;

    public MyCanvas(HelloMidlet _midlet) {
	midlet = _midlet;
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
	setCommandListener(this);
    }
    
   
    protected void paint(Graphics g) {

	int screenWidth  = getWidth();
	int screenHeight = getHeight();

	g.fillRect(0,0,screenWidth, screenHeight);
	
	g.setColor(255,0,100);
	g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_BOLD,Font.SIZE_LARGE));
	g.drawString("Prawo-Dol",screenWidth, screenHeight, Graphics.BOTTOM | Graphics.RIGHT );

	g.setColor(100,0,255);	
	g.setFont(Font.getFont(Font.FACE_MONOSPACE,Font.STYLE_UNDERLINED,Font.SIZE_MEDIUM));
	g.drawString("Lewo-Gora",0, 0, Graphics.TOP | Graphics.LEFT );

	g.setColor(60,255,60);	
	g.setFont(Font.getFont(Font.FACE_PROPORTIONAL,Font.STYLE_ITALIC,Font.SIZE_SMALL));
	g.drawString("Prawo-Gora",screenWidth, 0, Graphics.TOP | Graphics.RIGHT );

	g.setColor(155,100,155);	
	g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_ITALIC | Font.STYLE_BOLD,Font.SIZE_MEDIUM));
	g.drawString("Lewo-Dol",0, screenHeight, Graphics.BOTTOM | Graphics.LEFT );

	g.setColor(15,255,255);	
	g.setFont(Font.getFont(Font.FACE_SYSTEM,Font.STYLE_UNDERLINED | Font.STYLE_BOLD,Font.SIZE_LARGE));
	g.drawString("Srodek",screenWidth/2, screenHeight/2, Graphics.TOP | Graphics.HCENTER);

    }

    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) {
            case Command.EXIT:
                midlet.destroyApp( false );
                midlet.notifyDestroyed();
                break;
        }
    }
}
