package hello;

import java.io.*;
import javax.microedition.lcdui.*;

public class MyCanvas extends Canvas implements CommandListener{
   
   
    HelloMidlet midlet;
    Image myImage;

    public MyCanvas(HelloMidlet _midlet) {
	midlet = _midlet;
        addCommand( new Command( "Koniec", Command.EXIT, 0 ));
	setCommandListener(this);
    }
    
   
    protected void paint(Graphics g) {

	int screenWidth  = getWidth();
	int screenHeight = getHeight();

	g.fillRect(0,0,screenWidth, screenHeight);

        // jesli nie wczytano jeszcze bitmapy
	if (myImage == null) 
        {
	   try 
           {
              // zaladuj bitmape z pliku zasobow
	      myImage = Image.createImage("/test.png");
           } 
           catch (IOException ex) 
           {
              // wystapil blad, poinformuj uzytkownika
              g.setColor(0xffffff);
              g.drawString("Failed to load image!", 0, 0, Graphics.TOP | Graphics.LEFT);
              return;
           }
        }	

        // rysuj w prawym-dolnym rogu
	g.drawImage(myImage,screenWidth, screenHeight, Graphics.BOTTOM | Graphics.RIGHT );

	// rysuj w lewym-gornym rogu
	g.drawImage(myImage,0, 0, Graphics.TOP | Graphics.LEFT );

	// rysuj w prawym-gornym rogu
	g.drawImage(myImage,screenWidth, 0, Graphics.TOP | Graphics.RIGHT );

	// rysuj w lewym-dolnym rogu
	g.drawImage(myImage,0, screenHeight, Graphics.BOTTOM | Graphics.LEFT );

	// rysuj na srodku
	g.drawImage(myImage,screenWidth/2, screenHeight/2, Graphics.VCENTER | Graphics.HCENTER);

    }

    public void commandAction(Command c, Displayable d)
    {
        switch( c.getCommandType() ) {
            case Command.EXIT:
                midlet.destroyApp( false );
                midlet.notifyDestroyed();
                break;
        }
    }
}
