package hello;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.bluetooth.*;
import javax.microedition.io.*;
import javax.microedition.lcdui.*;

public class ServerConnectionScreen extends TimerTask
implements CommandListener {
    
    
    private static final int MAX_BAR_VALUE = 10;
    private static final int TIMER_FREQUENCY = 200;
    private final String serviceUUID = "7B801165D7A711DB9705005056C00008";
    private final String connectionParameters = ";authorize=false;authenticate=false;encrypt=false";
    
    MultiplayerGame midlet;
    
    private Gauge gauge;
    private Timer taskTimer;
    
    private LocalDevice localDevice;
    private StreamConnectionNotifier notifier;    
    private String localName;
    private int previousDiscoverabilityMode = -1;
    
    public ServerConnectionScreen(MultiplayerGame _midlet) {
        
        midlet = _midlet;
        
        gauge = new Gauge( "Czekam na polaczenie ...", false, MAX_BAR_VALUE, 0 );
        Command cmStop = new Command( "Cancel", Command.CANCEL, 1 );        
        
        Form form = new Form("");
        form.append(gauge);
        form.addCommand(cmStop);
        form.setCommandListener(this);                
        midlet.getMidletDisplay().setCurrent(form);
        
        taskTimer = new Timer();
        taskTimer.scheduleAtFixedRate( this, 0, TIMER_FREQUENCY);
        
        try {
            localDevice = LocalDevice.getLocalDevice();
        } catch(Exception e) {
            localDevice = null;
            String message = "Error trying to get local device properties: " + e.getMessage();
            System.out.println(message);
        }
        
        try {
            localName = LocalDevice.getLocalDevice().getFriendlyName();
            saveDiscoverability();
            localDevice.setDiscoverable( DiscoveryAgent.LIAC );        
        } catch( BluetoothStateException e ) {
            System.out.println("Please switch Bluetooth on!");
            return;
        }  
        
        AcceptAndOpenThread t = new AcceptAndOpenThread();
        t.start();        
    }
    
    private void saveDiscoverability() {
        try {
            previousDiscoverabilityMode =
            LocalDevice.getLocalDevice().getDiscoverable();
        } catch(Exception e) {}
    }
    
    private void restoreDiscoverability() {
        try {
            if(previousDiscoverabilityMode != -1) {
                localDevice.setDiscoverable(previousDiscoverabilityMode);
            }
        } catch( Exception e ) {}
    }
    
    public void run() {
        int time = gauge.getValue() + 1;
        if(time > gauge.getMaxValue())
            time = 0;
        gauge.setValue( time );
    }
    
    protected void stop() {
        cancel();
        taskTimer.cancel();
    }
    
    public void connectionDiscoveryFinished(BluetoothConnection btConnection)
    {
        restoreDiscoverability();
        
        if(btConnection == null)
        {                      
            stop();
            midlet.startUI();            
        }
        else            
        {
            MyCanvas nc = new MyCanvas( new BluetoothConnection[] { btConnection}, midlet,false );                        
            midlet.getMidletDisplay().setCurrent( nc );            
            stop();
        }
    }
    
    public void commandAction(Command c, Displayable s) {
        switch( c.getCommandType() ) {
            case Command.CANCEL:
            closeNotifier();
            stop();
            restoreDiscoverability();
            midlet.startUI();
            break;
        }
    }
    
    
    synchronized private void closeNotifier() {
        if(notifier != null) {
            try {
                notifier.close();
            } catch(Exception e) {
                String message = "Error trying to close notifier" + e.getMessage();
                System.out.println(message);
            }
            notifier = null;
        }
    }
    
    private class AcceptAndOpenThread extends Thread {
        
        public void run() {            
            BluetoothConnection btConnection;
            
            try {
                notifier = (StreamConnectionNotifier) Connector.open(
                "btspp://localhost:" + serviceUUID + ";name=" +
                localName + connectionParameters);
                
                StreamConnection streamConnection = (StreamConnection) notifier.acceptAndOpen();
                btConnection = new BluetoothConnection(streamConnection, localName, "Host");               
            } catch(Exception e) {
                btConnection = null;
            }
            closeNotifier();
            connectionDiscoveryFinished(btConnection);
        }
    }
}
