package hello;

import java.lang.Math.*;
import javax.microedition.m3g.*;

public class AIPlayer extends Player
{
    final float DIST_TO_SWITCH_NAVIPOINT = 0.3f;
    
    private float speed = 0.f;
    Game game = null;
    
    private NavigationPoint currentNavPoint = null;
    
    public AIPlayer(Mesh mesh, Game gameInstance, float _speed)
    {
        
        super(mesh);
        
        game = gameInstance;    
        speed = _speed;
        
        mesh.setPickingEnable(false);
        currentNavPoint = game.getTrack().getFirstNavigationPoint();
    }
    
    public void update(float deltaTime)
    {
        if((currentNavPoint == null)||(iNumLaps==3))
            return;
        
        float[] naviPos = currentNavPoint.getPosition();
        
        float x = naviPos[0] - position[0];
        float y = naviPos[1] - position[1];
        
        float length = (float)Math.sqrt(x*x + y*y);
        x/=length;
        y/=length;
        
        x*=speed;
        y*=speed;
        
        boolean passedStartLine = game.getTrack().checkPassedStartLine(
        position[0],position[1],position[2],position[0]+x,position[1]+y,position[2]);
        
        if(passedStartLine == true)
        {        
            ++iNumLaps;
            System.out.println("AI player - Next lap!");        
            if(iNumLaps == 3)
            {
                game.reportPlayerOnFinish(this);
            }
        }
        
        position[0] += x;
        position[1] += y;       
        
        playerMesh.setTranslation(position[0], position[1], position[2]);
        
        if(length < DIST_TO_SWITCH_NAVIPOINT)
        {
            currentNavPoint = currentNavPoint.getNext();
        }
        
        updateHeight(deltaTime);
    }
    
    public void updateHeight(float deltaTime)
    {
        float distance = game.getTrack().getDistanceToGround(position);
        
        float distanceDelta = distance - PREFERED_GROUND_DIST;
        position[2] -= distanceDelta/4.f;
    } 
}