package hello;

import javax.microedition.m3g.*;

public class Track
{  
    final int NAV_POINT_MIN_ID = 100;
    final int NAV_POINT_MAX_ID = 140;
    final int TRACK_SCOPE = 2;
    final int START_LINE_SCOPE = 8;   
    final int TRACK_MESH_ID = 2;
    final int START_LINE_MESH_ID = 3;
    
    World world;
    
    NavigationPoint firstNaviPoint;
    
    public Track() {}
    
    public NavigationPoint getFirstNavigationPoint() { return firstNaviPoint; }
    
    public void initialize(World _world)
    {
        world = _world;
        constructNavigationPath(_world);
        
        Mesh trackMesh = (Mesh)world.find(TRACK_MESH_ID);
        if(trackMesh == null) 
        {
            System.out.println("Brak siatki trasy!");
        }
        else
        {
            trackMesh.setScope(TRACK_SCOPE);
        }
        
        Mesh startLineMesh = (Mesh)world.find(START_LINE_MESH_ID);
        if(startLineMesh == null) 
        {
            System.out.println("Brak siatki lini startowej!");
        }
        else
        {
            startLineMesh.setScope(START_LINE_SCOPE);
            startLineMesh.setRenderingEnable(false);
        }      
    }
    
    public boolean isGroundBelow(float[] position)
    {
        return world.pick(TRACK_SCOPE,position[0],position[1],position[2],0,0,-1,new RayIntersection());
    }
    
    public float getDistanceToGround(float[] position)
    {
        RayIntersection ri = new RayIntersection();
        
        world.pick(TRACK_SCOPE,position[0],position[1],position[2],0,0,-1,ri);
        return ri.getDistance();
    }
    
    public boolean checkPassedStartLine(
    float x0,float y0,float z0,float x1,float y1,float z1)
    {           
        RayIntersection ri = new RayIntersection();
        
        float dirX = x1-x0;
        float dirY = y1-y0;     
        // stoimy w miejscu
        if((dirX==0.f) && (dirY == 0))
            return false;
        
        // sprawdz zaistnienie kolizji i czy nastapila w odpowiedniej odleglosci
        boolean hit = world.pick(START_LINE_SCOPE,x0,y0,z0,dirX,dirY,0,ri);
        if(hit == true)
        {
            float hitDistance = ri.getDistance();
            return (hitDistance>=0) && (hitDistance<=1.f);
        }
        else
        {
            return false;
        }
    }
    
    private boolean constructNavigationPath(World world)
    {
        NavigationPoint currNaviPoint;
        float[] naviPointTransform = new float[16];
        
        Mesh naviPointMesh = (Mesh)world.find(NAV_POINT_MIN_ID);
        if(naviPointMesh == null)
        {
            System.out.println("No starting navi point found!");
            return false;
        }
        
        Transform transform = new Transform();
        naviPointMesh.getCompositeTransform(transform);
        transform.get(naviPointTransform);
        naviPointMesh.setPickingEnable(false);
        naviPointMesh.setRenderingEnable(false);
        
        currNaviPoint = firstNaviPoint = new NavigationPoint(
        new float[] {naviPointTransform[3],naviPointTransform[7],naviPointTransform[11]});
        
        for(int i=NAV_POINT_MIN_ID+1 ; i<NAV_POINT_MAX_ID ; i++)
        {
            // znajdz nastepny navi-point
            naviPointMesh = (Mesh)world.find(i);
            if(naviPointMesh == null)
            {   // to byl ostatni navi-point, zamknij cyklicznie
                currNaviPoint.setNext(firstNaviPoint);
                break;
            }
            else
            {
                naviPointMesh.setPickingEnable(false);
                naviPointMesh.setRenderingEnable(false);                
                // dowiaz do listy kolejny navi-point
                naviPointMesh.getCompositeTransform(transform);
                transform.get(naviPointTransform);
                
                NavigationPoint nextNaviPoint = new NavigationPoint(
                new float[] {naviPointTransform[3],
                    naviPointTransform[7],
                naviPointTransform[11]});
                
                currNaviPoint.setNext(nextNaviPoint);
                currNaviPoint = nextNaviPoint;
            }         
        }       
        return true;
    }
}